// $codepro.audit.disable
/**
 * Aptana Studio
 * Copyright (c) 2005-2012 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the GNU Public License (GPL) v3 (with exceptions).
 * Please see the license.html included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
package com.aptana.editor.js.parsing;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import beaver.Scanner;
import beaver.Symbol;

import com.aptana.editor.js.parsing.lexer.JSTokenType;

/**
 * This class is a scanner generated by <a href="http://www.jflex.de/">JFlex</a> 1.4.3 on 4/27/12 10:55 AM from the
 * specification file <tt>JS.flex</tt>
 */
public class JSFlexScanner extends Scanner
{

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
	private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
	public static final int YYINITIAL = 0;
	public static final int REGEX = 4;
	public static final int DIVISION = 2;

	/**
	 * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l ZZ_LEXSTATE[l+1] is the state in the DFA for the
	 * lexical state l at the beginning of a line l is of the form l = 2*k, k a non negative integer
	 */
	private static final int ZZ_LEXSTATE[] = { 0, 0, 1, 1, 2, 2 };

	/**
	 * Translates characters to character classes
	 */
	private static final String ZZ_CMAP_PACKED = "\11\12\1\10\1\1\1\0\1\10\1\1\16\12\4\0\1\10\1\61"
			+ "\1\23\1\0\1\11\1\3\1\62\1\25\1\70\1\71\1\27\1\22" + "\1\72\1\64\1\20\1\26\1\14\11\17\1\73\1\67\1\2\1\60"
			+ "\1\4\1\5\1\0\4\16\1\21\1\16\21\11\1\15\2\11\1\30" + "\1\24\1\31\1\65\1\11\1\0\1\40\1\36\1\42\1\52\1\35"
			+ "\1\34\1\32\1\45\1\50\1\32\1\41\1\53\1\32\1\47\1\46"
			+ "\1\56\1\32\1\37\1\43\1\44\1\51\1\57\1\55\1\33\1\54" + "\1\32\1\6\1\63\1\7\1\66\41\12\2\0\4\11\4\0\1\11"
			+ "\2\0\1\12\7\0\1\11\4\0\1\11\5\0\27\11\1\0\37\11"
			+ "\1\0\u013f\11\31\0\162\11\4\0\14\11\16\0\5\11\11\0\1\11"
			+ "\21\0\130\12\5\0\23\12\12\0\1\11\13\0\1\11\1\0\3\11"
			+ "\1\0\1\11\1\0\24\11\1\0\54\11\1\0\46\11\1\0\5\11" + "\4\0\202\11\1\0\4\12\3\0\105\11\1\0\46\11\2\0\2\11"
			+ "\6\0\20\11\41\0\46\11\2\0\1\11\7\0\47\11\11\0\21\12" + "\1\0\27\12\1\0\3\12\1\0\1\12\1\0\2\12\1\0\1\12"
			+ "\13\0\33\11\5\0\3\11\15\0\4\12\14\0\6\12\13\0\32\11"
			+ "\5\0\13\11\16\12\7\0\12\13\4\0\2\11\1\12\143\11\1\0"
			+ "\1\11\10\12\1\0\6\12\2\11\2\12\1\0\4\12\2\11\12\13"
			+ "\3\11\2\0\1\11\17\0\1\12\1\11\1\12\36\11\33\12\2\0"
			+ "\3\11\60\0\46\11\13\12\1\11\u014f\0\3\12\66\11\2\0\1\12"
			+ "\1\11\20\12\2\0\1\11\4\12\3\0\12\11\2\12\2\0\12\13" + "\21\0\3\12\1\0\10\11\2\0\2\11\2\0\26\11\1\0\7\11"
			+ "\1\0\1\11\3\0\4\11\2\0\1\12\1\11\7\12\2\0\2\12" + "\2\0\3\12\11\0\1\12\4\0\2\11\1\0\3\11\2\12\2\0"
			+ "\12\13\4\11\15\0\3\12\1\0\6\11\4\0\2\11\2\0\26\11" + "\1\0\7\11\1\0\2\11\1\0\2\11\1\0\2\11\2\0\1\12"
			+ "\1\0\5\12\4\0\2\12\2\0\3\12\13\0\4\11\1\0\1\11" + "\7\0\12\13\2\12\3\11\14\0\3\12\1\0\11\11\1\0\3\11"
			+ "\1\0\26\11\1\0\7\11\1\0\2\11\1\0\5\11\2\0\1\12" + "\1\11\10\12\1\0\3\12\1\0\3\12\2\0\1\11\17\0\2\11"
			+ "\2\12\2\0\12\13\1\0\1\11\17\0\3\12\1\0\10\11\2\0" + "\2\11\2\0\26\11\1\0\7\11\1\0\2\11\1\0\5\11\2\0"
			+ "\1\12\1\11\6\12\3\0\2\12\2\0\3\12\10\0\2\12\4\0" + "\2\11\1\0\3\11\4\0\12\13\1\0\1\11\20\0\1\12\1\11"
			+ "\1\0\6\11\3\0\3\11\1\0\4\11\3\0\2\11\1\0\1\11" + "\1\0\2\11\3\0\2\11\3\0\3\11\3\0\10\11\1\0\3\11"
			+ "\4\0\5\12\3\0\3\12\1\0\4\12\11\0\1\12\17\0\11\13" + "\11\0\1\11\7\0\3\12\1\0\10\11\1\0\3\11\1\0\27\11"
			+ "\1\0\12\11\1\0\5\11\4\0\7\12\1\0\3\12\1\0\4\12" + "\7\0\2\12\11\0\2\11\4\0\12\13\22\0\2\12\1\0\10\11"
			+ "\1\0\3\11\1\0\27\11\1\0\12\11\1\0\5\11\2\0\1\12" + "\1\11\7\12\1\0\3\12\1\0\4\12\7\0\2\12\7\0\1\11"
			+ "\1\0\2\11\4\0\12\13\22\0\2\12\1\0\10\11\1\0\3\11" + "\1\0\27\11\1\0\20\11\4\0\6\12\2\0\3\12\1\0\4\12"
			+ "\11\0\1\12\10\0\2\11\4\0\12\13\22\0\2\12\1\0\22\11" + "\3\0\30\11\1\0\11\11\1\0\1\11\2\0\7\11\3\0\1\12"
			+ "\4\0\6\12\1\0\1\12\1\0\10\12\22\0\2\12\15\0\60\11"
			+ "\1\12\2\11\7\12\4\0\10\11\10\12\1\0\12\13\47\0\2\11" + "\1\0\1\11\2\0\2\11\1\0\1\11\2\0\1\11\6\0\4\11"
			+ "\1\0\7\11\1\0\3\11\1\0\1\11\1\0\1\11\2\0\2\11" + "\1\0\4\11\1\12\2\11\6\12\1\0\2\12\1\11\2\0\5\11"
			+ "\1\0\1\11\1\0\6\12\2\0\12\13\2\0\2\11\42\0\1\11" + "\27\0\2\12\6\0\12\13\13\0\1\12\1\0\1\12\1\0\1\12"
			+ "\4\0\2\12\10\11\1\0\42\11\6\0\24\12\1\0\2\12\4\11"
			+ "\4\0\10\12\1\0\44\12\11\0\1\12\71\0\42\11\1\0\5\11" + "\1\0\2\11\1\0\7\12\3\0\4\12\6\0\12\13\6\0\6\11"
			+ "\4\12\106\0\46\11\12\0\51\11\7\0\132\11\5\0\104\11\5\0"
			+ "\122\11\6\0\7\11\1\0\77\11\1\0\1\11\1\0\4\11\2\0" + "\7\11\1\0\1\11\1\0\4\11\2\0\47\11\1\0\1\11\1\0"
			+ "\4\11\2\0\37\11\1\0\1\11\1\0\4\11\2\0\7\11\1\0" + "\1\11\1\0\4\11\2\0\7\11\1\0\7\11\1\0\27\11\1\0"
			+ "\37\11\1\0\1\11\1\0\4\11\2\0\7\11\1\0\47\11\1\0"
			+ "\23\11\16\0\11\13\56\0\125\11\14\0\u026c\11\2\0\10\11\12\0"
			+ "\32\11\5\0\113\11\3\0\3\11\17\0\15\11\1\0\4\11\3\12"
			+ "\13\0\22\11\3\12\13\0\22\11\2\12\14\0\15\11\1\0\3\11"
			+ "\1\0\2\12\14\0\64\11\40\12\3\0\1\11\3\0\2\11\1\12"
			+ "\2\0\12\13\41\0\3\12\2\0\12\13\6\0\130\11\10\0\51\11"
			+ "\1\12\126\0\35\11\3\0\14\12\4\0\14\12\12\0\12\13\36\11"
			+ "\2\0\5\11\u038b\0\154\11\224\0\234\11\4\0\132\11\6\0\26\11"
			+ "\2\0\6\11\2\0\46\11\2\0\6\11\2\0\10\11\1\0\1\11" + "\1\0\1\11\1\0\1\11\1\0\37\11\2\0\65\11\1\0\7\11"
			+ "\1\0\1\11\3\0\3\11\1\0\7\11\3\0\4\11\2\0\6\11" + "\4\0\15\11\5\0\3\11\1\0\7\11\17\0\4\12\32\0\5\12"
			+ "\20\0\2\11\23\0\1\11\13\0\4\12\6\0\6\12\1\0\1\11" + "\15\0\1\11\40\0\22\11\36\0\15\12\4\0\1\12\3\0\6\12"
			+ "\27\0\1\11\4\0\1\11\2\0\12\11\1\0\1\11\3\0\5\11" + "\6\0\1\11\1\0\1\11\1\0\1\11\1\0\4\11\1\0\3\11"
			+ "\1\0\7\11\3\0\3\11\5\0\5\11\26\0\44\11\u0e81\0\3\11"
			+ "\31\0\11\11\6\12\1\0\5\11\2\0\5\11\4\0\126\11\2\0"
			+ "\2\12\2\0\3\11\1\0\137\11\5\0\50\11\4\0\136\11\21\0"
			+ "\30\11\70\0\20\11\u0200\0\u19b6\11\112\0\u51a6\11\132\0\u048d\11\u0773\0"
			+ "\u2ba4\11\u215c\0\u012e\11\2\0\73\11\225\0\7\11\14\0\5\11\5\0"
			+ "\1\11\1\12\12\11\1\0\15\11\1\0\5\11\1\0\1\11\1\0"
			+ "\2\11\1\0\2\11\1\0\154\11\41\0\u016b\11\22\0\100\11\2\0"
			+ "\66\11\50\0\15\11\3\0\20\12\20\0\4\12\17\0\2\11\30\0"
			+ "\3\11\31\0\1\11\6\0\5\11\1\0\207\11\2\0\1\12\4\0" + "\1\11\13\0\12\13\7\0\32\11\4\0\1\11\1\0\32\11\12\0"
			+ "\132\11\3\0\6\11\2\0\6\11\2\0\6\11\2\0\3\11\3\0" + "\2\11\3\0\2\11\22\0\3\12\4\0";

	/**
	 * Translates characters to character classes
	 */
	private static final char[] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

	/**
	 * Translates DFA states to action switch labels.
	 */
	private static final int[] ZZ_ACTION = zzUnpackAction();

	private static final String ZZ_ACTION_PACKED_0 = "\3\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"
			+ "\1\10\1\11\2\12\1\13\1\14\2\1\1\15\1\16" + "\1\17\1\20\14\11\1\21\1\22\1\23\1\24\1\25"
			+ "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\3\1" + "\2\35\2\0\1\36\2\0\1\37\1\40\1\41\1\42"
			+ "\1\0\1\12\2\0\1\43\1\44\1\0\1\45\1\1" + "\1\0\1\1\1\46\1\0\1\47\17\11\1\50\1\51"
			+ "\1\11\1\52\4\11\1\53\1\54\1\55\1\56\1\57" + "\1\60\1\61\1\62\1\63\1\64\3\0\1\64\1\65"
			+ "\2\0\1\66\1\67\1\0\1\12\1\0\1\12\2\0" + "\1\46\1\70\2\0\1\11\1\71\12\11\1\72\3\11"
			+ "\1\73\6\11\1\74\1\11\1\75\1\76\1\77\1\0" + "\1\100\2\0\1\101\1\0\3\11\1\102\2\11\1\103"
			+ "\4\11\1\104\1\11\1\105\1\11\1\106\4\11\1\107" + "\1\110\1\101\1\111\1\112\2\11\1\113\1\11\1\114"
			+ "\2\11\1\115\4\11\1\116\2\11\1\117\1\11\1\120" + "\1\121\2\11\1\122\1\123\3\11\1\124\1\125\1\126"
			+ "\2\11\1\127";

	private static int[] zzUnpackAction()
	{
		int[] result = new int[217];
		int offset = 0;
		offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
		return result;
	}

	private static int zzUnpackAction(String packed, int offset, int[] result)
	{
		int i = 0; /* index in packed string */
		int j = offset; /* index in unpacked array */
		int l = packed.length();
		while (i < l)
		{
			int count = packed.charAt(i++);
			int value = packed.charAt(i++);
			do
				result[j++] = value;
			while (--count > 0);
		}
		return j;
	}

	/**
	 * Translates a state to a row index in the transition table
	 */
	private static final int[] ZZ_ROWMAP = zzUnpackRowMap();

	private static final String ZZ_ROWMAP_PACKED_0 = "\0\0\0\74\0\170\0\264\0\360\0\u012c\0\u0168\0\u01a4"
			+ "\0\264\0\u01e0\0\264\0\u021c\0\u0258\0\u0294\0\u02d0\0\u030c"
			+ "\0\u0348\0\u0384\0\u03c0\0\u03fc\0\264\0\264\0\u0438\0\u0474"
			+ "\0\u04b0\0\u04ec\0\u0528\0\u0564\0\u05a0\0\u05dc\0\u0618\0\u0654"
			+ "\0\u0690\0\u06cc\0\u0708\0\u0744\0\u0780\0\u07bc\0\u07f8\0\u0834"
			+ "\0\264\0\264\0\264\0\264\0\264\0\264\0\u0870\0\u01e0"
			+ "\0\u08ac\0\u08e8\0\u0924\0\u0870\0\u01e0\0\u0960\0\u099c\0\u09d8"
			+ "\0\264\0\264\0\u0a14\0\264\0\u0a50\0\u0a8c\0\u0ac8\0\u0b04"
			+ "\0\264\0\264\0\u0b40\0\264\0\u0b7c\0\u0bb8\0\u0bf4\0\u0c30"
			+ "\0\u0c6c\0\264\0\u0ca8\0\u0ce4\0\u0d20\0\u0d5c\0\u0d98\0\u0dd4"
			+ "\0\u0e10\0\u0e4c\0\u0e88\0\u0ec4\0\u0f00\0\u0f3c\0\u0f78\0\u0fb4"
			+ "\0\u0ff0\0\u021c\0\u102c\0\u1068\0\u021c\0\u10a4\0\u10e0\0\u111c"
			+ "\0\u1158\0\u1194\0\u11d0\0\264\0\264\0\264\0\264\0\264"
			+ "\0\264\0\264\0\264\0\u120c\0\u1248\0\u1284\0\u120c\0\264"
			+ "\0\u12c0\0\u12fc\0\u1338\0\264\0\u1374\0\u13b0\0\u13b0\0\u0b04"
			+ "\0\u0b7c\0\u0bf4\0\u13ec\0\u1428\0\u1464\0\u14a0\0\u14dc\0\u021c"
			+ "\0\u1518\0\u1554\0\u1590\0\u15cc\0\u1608\0\u1644\0\u1680\0\u16bc"
			+ "\0\u16f8\0\u1734\0\u021c\0\u1770\0\u17ac\0\u17e8\0\u021c\0\u1824"
			+ "\0\u1860\0\u189c\0\u18d8\0\u1914\0\u1950\0\u021c\0\u198c\0\264"
			+ "\0\264\0\u19c8\0\u1a04\0\264\0\u1a40\0\u1a7c\0\u1a7c\0\u1ab8"
			+ "\0\u1af4\0\u1b30\0\u1b6c\0\u021c\0\u1ba8\0\u1be4\0\u021c\0\u1c20"
			+ "\0\u1c5c\0\u1c98\0\u1cd4\0\u021c\0\u1d10\0\u021c\0\u1d4c\0\u021c"
			+ "\0\u1d88\0\u1dc4\0\u1e00\0\u1e3c\0\u021c\0\u021c\0\264\0\264"
			+ "\0\u021c\0\u1e78\0\u1eb4\0\u021c\0\u1ef0\0\u021c\0\u1f2c\0\u1f68"
			+ "\0\u021c\0\u1fa4\0\u1fe0\0\u201c\0\u2058\0\u021c\0\u2094\0\u20d0"
			+ "\0\u021c\0\u210c\0\u021c\0\u021c\0\u2148\0\u2184\0\u021c\0\u021c"
			+ "\0\u21c0\0\u21fc\0\u2238\0\u021c\0\u021c\0\u021c\0\u2274\0\u22b0" + "\0\u021c";

	private static int[] zzUnpackRowMap()
	{
		int[] result = new int[217];
		int offset = 0;
		offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
		return result;
	}

	private static int zzUnpackRowMap(String packed, int offset, int[] result)
	{
		int i = 0; /* index in packed string */
		int j = offset; /* index in unpacked array */
		int l = packed.length();
		while (i < l)
		{
			int high = packed.charAt(i++) << 16;
			result[j++] = high | packed.charAt(i++);
		}
		return j;
	}

	/**
	 * The transition table of the DFA
	 */
	private static final int[] ZZ_TRANS = zzUnpackTrans();

	private static final String ZZ_TRANS_PACKED_0 = "\1\4\1\5\1\6\1\7\1\10\1\11\1\12\1\13"
			+ "\1\5\1\14\1\4\1\15\1\16\2\14\1\15\1\17" + "\1\14\1\20\1\21\1\4\1\22\1\23\1\24\1\25"
			+ "\1\26\2\14\1\27\1\30\1\31\1\32\2\14\1\33" + "\1\34\1\35\2\14\1\36\1\37\1\14\1\40\2\14"
			+ "\1\41\1\14\1\42\1\43\1\44\1\45\1\46\1\47" + "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\4"
			+ "\1\5\1\57\3\4\1\60\1\4\1\5\12\4\1\61" + "\1\4\1\61\1\62\46\4\1\5\1\57\3\4\1\60"
			+ "\1\4\1\5\12\4\1\61\1\4\1\61\1\63\45\4" + "\75\0\1\5\1\64\3\0\1\65\1\0\1\5\65\0"
			+ "\1\66\1\67\1\0\1\70\52\0\1\71\73\0\1\72" + "\17\0\1\73\53\0\1\74\16\0\1\75\101\0\7\14"
			+ "\1\0\1\14\10\0\26\14\27\0\2\15\2\0\1\15" + "\1\76\1\77\13\0\1\77\51\0\2\15\1\100\1\0"
			+ "\1\15\1\76\1\77\11\0\1\100\1\0\1\77\51\0" + "\2\76\2\0\1\76\76\0\1\101\35\0\1\102\13\0"
			+ "\1\103\1\0\21\103\1\104\1\105\47\103\1\106\1\0" + "\22\106\1\107\1\104\46\106\26\0\1\110\1\111\124\0"
			+ "\1\112\24\0\7\14\1\0\1\14\10\0\6\14\1\113" + "\5\14\1\114\1\14\1\115\1\116\6\14\25\0\7\14"
			+ "\1\0\1\14\10\0\21\14\1\117\4\14\25\0\7\14" + "\1\0\1\14\10\0\5\14\1\120\20\14\25\0\7\14"
			+ "\1\0\1\14\10\0\3\14\1\121\22\14\25\0\7\14" + "\1\0\1\14\10\0\6\14\1\122\5\14\1\123\11\14"
			+ "\25\0\7\14\1\0\1\14\10\0\23\14\1\124\2\14" + "\25\0\7\14\1\0\1\14\10\0\5\14\1\125\5\14"
			+ "\1\126\6\14\1\127\3\14\25\0\7\14\1\0\1\14" + "\10\0\3\14\1\130\13\14\1\131\6\14\25\0\7\14"
			+ "\1\0\1\14\10\0\2\14\1\132\12\14\1\133\10\14" + "\25\0\7\14\1\0\1\14\10\0\3\14\1\134\10\14"
			+ "\1\135\11\14\25\0\7\14\1\0\1\14\10\0\13\14" + "\1\136\2\14\1\137\7\14\25\0\7\14\1\0\1\14"
			+ "\10\0\6\14\1\140\5\14\1\141\11\14\74\0\1\142" + "\73\0\1\143\73\0\1\144\1\0\1\145\71\0\1\146"
			+ "\2\0\1\147\70\0\1\150\3\0\1\151\67\0\1\152" + "\16\0\1\67\1\0\1\70\112\0\1\4\127\0\1\153"
			+ "\13\0\1\154\1\0\22\154\1\155\1\154\1\0\1\154" + "\1\156\27\154\1\157\13\154\60\0\1\160\13\0\3\67"
			+ "\1\161\70\67\5\70\1\162\66\70\4\0\1\163\53\0" + "\1\164\13\0\3\75\1\165\70\75\13\0\2\76\2\0"
			+ "\1\76\1\0\1\77\13\0\1\77\51\0\2\166\2\0" + "\1\166\2\0\1\167\41\0\1\167\23\0\1\170\1\0"
			+ "\2\170\1\0\1\170\12\0\3\170\1\0\1\170\1\0" + "\1\170\7\0\1\170\21\0\1\103\1\0\21\103\1\104"
			+ "\1\171\143\103\1\106\1\0\22\106\1\172\1\104\142\106"
			+ "\1\173\1\0\24\173\1\174\45\173\27\175\1\176\44\175" + "\11\0\7\14\1\0\1\14\10\0\21\14\1\177\4\14"
			+ "\25\0\7\14\1\0\1\14\10\0\5\14\1\200\20\14" + "\25\0\7\14\1\0\1\14\10\0\15\14\1\201\10\14"
			+ "\25\0\7\14\1\0\1\14\10\0\15\14\1\202\10\14" + "\25\0\7\14\1\0\1\14\10\0\11\14\1\203\14\14"
			+ "\25\0\7\14\1\0\1\14\10\0\3\14\1\204\22\14" + "\25\0\7\14\1\0\1\14\10\0\12\14\1\205\13\14"
			+ "\25\0\7\14\1\0\1\14\10\0\11\14\1\206\1\207" + "\13\14\25\0\7\14\1\0\1\14\10\0\15\14\1\210"
			+ "\10\14\25\0\7\14\1\0\1\14\10\0\16\14\1\211" + "\7\14\25\0\7\14\1\0\1\14\10\0\17\14\1\212"
			+ "\2\14\1\213\3\14\25\0\7\14\1\0\1\14\10\0" + "\5\14\1\214\10\14\1\215\7\14\25\0\7\14\1\0"
			+ "\1\14\10\0\24\14\1\216\1\14\25\0\7\14\1\0" + "\1\14\10\0\23\14\1\217\2\14\25\0\7\14\1\0"
			+ "\1\14\10\0\21\14\1\220\4\14\25\0\7\14\1\0" + "\1\14\10\0\11\14\1\221\14\14\25\0\7\14\1\0"
			+ "\1\14\10\0\2\14\1\222\16\14\1\223\4\14\25\0" + "\7\14\1\0\1\14\10\0\16\14\1\224\7\14\25\0"
			+ "\7\14\1\0\1\14\10\0\12\14\1\225\13\14\25\0" + "\7\14\1\0\1\14\10\0\5\14\1\226\20\14\25\0"
			+ "\7\14\1\0\1\14\10\0\16\14\1\227\7\14\74\0" + "\1\230\73\0\1\231\13\0\1\154\1\0\22\154\1\155"
			+ "\1\154\1\232\1\154\1\156\44\154\1\0\72\154\1\156" + "\1\0\22\156\1\233\4\156\1\154\42\156\3\67\1\161"
			+ "\1\5\67\67\4\70\1\5\1\162\66\70\60\0\1\234" + "\13\0\3\75\1\165\3\75\1\5\64\75\13\0\2\166"
			+ "\2\0\1\166\54\0\1\173\1\0\72\173\1\174\1\0" + "\72\174\27\175\1\235\44\175\26\236\1\237\1\240\44\236"
			+ "\11\0\7\14\1\0\1\14\10\0\11\14\1\241\14\14" + "\25\0\7\14\1\0\1\14\10\0\6\14\1\242\17\14"
			+ "\25\0\7\14\1\0\1\14\10\0\10\14\1\243\15\14" + "\25\0\7\14\1\0\1\14\10\0\3\14\1\244\22\14"
			+ "\25\0\7\14\1\0\1\14\10\0\6\14\1\245\17\14" + "\25\0\7\14\1\0\1\14\10\0\17\14\1\246\6\14"
			+ "\25\0\7\14\1\0\1\14\10\0\3\14\1\247\22\14" + "\25\0\7\14\1\0\1\14\10\0\10\14\1\250\15\14"
			+ "\25\0\7\14\1\0\1\14\10\0\11\14\1\251\1\252" + "\13\14\25\0\7\14\1\0\1\14\10\0\12\14\1\253"
			+ "\13\14\25\0\7\14\1\0\1\14\10\0\3\14\1\254" + "\22\14\25\0\7\14\1\0\1\14\10\0\14\14\1\255"
			+ "\11\14\25\0\7\14\1\0\1\14\10\0\11\14\1\256" + "\14\14\25\0\7\14\1\0\1\14\10\0\3\14\1\257"
			+ "\22\14\25\0\7\14\1\0\1\14\10\0\21\14\1\260" + "\4\14\25\0\7\14\1\0\1\14\10\0\12\14\1\261"
			+ "\13\14\25\0\7\14\1\0\1\14\10\0\6\14\1\262" + "\17\14\25\0\7\14\1\0\1\14\10\0\3\14\1\263"
			+ "\22\14\25\0\7\14\1\0\1\14\10\0\21\14\1\264" + "\4\14\25\0\7\14\1\0\1\14\10\0\13\14\1\265"
			+ "\12\14\25\0\7\14\1\0\1\14\10\0\20\14\1\266" + "\5\14\46\0\26\232\14\0\1\156\1\0\72\156\26\175"
			+ "\1\267\1\235\44\175\27\236\1\240\72\236\1\270\1\240" + "\44\236\11\0\7\14\1\0\1\14\10\0\3\14\1\271"
			+ "\22\14\25\0\7\14\1\0\1\14\10\0\21\14\1\272" + "\4\14\25\0\7\14\1\0\1\14\10\0\12\14\1\273"
			+ "\13\14\25\0\7\14\1\0\1\14\10\0\7\14\1\274" + "\16\14\25\0\7\14\1\0\1\14\10\0\5\14\1\275"
			+ "\20\14\25\0\7\14\1\0\1\14\10\0\13\14\1\276" + "\12\14\25\0\7\14\1\0\1\14\10\0\12\14\1\226"
			+ "\13\14\25\0\7\14\1\0\1\14\10\0\16\14\1\277" + "\7\14\25\0\7\14\1\0\1\14\10\0\10\14\1\300"
			+ "\15\14\25\0\7\14\1\0\1\14\10\0\23\14\1\301" + "\2\14\25\0\7\14\1\0\1\14\10\0\14\14\1\302"
			+ "\11\14\25\0\7\14\1\0\1\14\10\0\6\14\1\303" + "\17\14\25\0\7\14\1\0\1\14\10\0\17\14\1\304"
			+ "\6\14\25\0\7\14\1\0\1\14\10\0\12\14\1\305" + "\13\14\25\0\7\14\1\0\1\14\10\0\3\14\1\306"
			+ "\22\14\25\0\7\14\1\0\1\14\10\0\21\14\1\307" + "\4\14\25\0\7\14\1\0\1\14\10\0\16\14\1\310"
			+ "\7\14\25\0\7\14\1\0\1\14\10\0\15\14\1\311" + "\10\14\25\0\7\14\1\0\1\14\10\0\15\14\1\312"
			+ "\10\14\25\0\7\14\1\0\1\14\10\0\13\14\1\313" + "\12\14\25\0\7\14\1\0\1\14\10\0\2\14\1\314"
			+ "\23\14\25\0\7\14\1\0\1\14\10\0\15\14\1\315" + "\10\14\25\0\7\14\1\0\1\14\10\0\21\14\1\316"
			+ "\4\14\25\0\7\14\1\0\1\14\10\0\3\14\1\317" + "\22\14\25\0\7\14\1\0\1\14\10\0\22\14\1\320"
			+ "\3\14\25\0\7\14\1\0\1\14\10\0\14\14\1\321" + "\11\14\25\0\7\14\1\0\1\14\10\0\17\14\1\322"
			+ "\6\14\25\0\7\14\1\0\1\14\10\0\10\14\1\323" + "\15\14\25\0\7\14\1\0\1\14\10\0\12\14\1\324"
			+ "\13\14\25\0\7\14\1\0\1\14\10\0\15\14\1\325" + "\10\14\25\0\7\14\1\0\1\14\10\0\3\14\1\326"
			+ "\22\14\25\0\7\14\1\0\1\14\10\0\3\14\1\327" + "\22\14\25\0\7\14\1\0\1\14\10\0\14\14\1\330"
			+ "\11\14\25\0\7\14\1\0\1\14\10\0\2\14\1\331" + "\23\14\14\0";

	private static int[] zzUnpackTrans()
	{
		int[] result = new int[8940];
		int offset = 0;
		offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
		return result;
	}

	private static int zzUnpackTrans(String packed, int offset, int[] result)
	{
		int i = 0; /* index in packed string */
		int j = offset; /* index in unpacked array */
		int l = packed.length();
		while (i < l)
		{
			int count = packed.charAt(i++);
			int value = packed.charAt(i++);
			value--;
			do
				result[j++] = value;
			while (--count > 0);
		}
		return j;
	}

	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = { "Unkown internal scanner error", "Error: could not match input",
			"Error: pushback value was too large" };

	/**
	 * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
	 */
	private static final int[] ZZ_ATTRIBUTE = zzUnpackAttribute();

	private static final String ZZ_ATTRIBUTE_PACKED_0 = "\3\0\1\11\4\1\1\11\1\1\1\11\11\1\2\11"
			+ "\22\1\6\11\5\1\2\0\1\1\2\0\2\11\1\1" + "\1\11\1\0\1\1\2\0\2\11\1\0\1\11\1\1"
			+ "\1\0\2\1\1\0\1\11\31\1\10\11\3\0\1\1" + "\1\11\2\0\1\1\1\11\1\0\1\1\1\0\1\1"
			+ "\2\0\2\1\2\0\31\1\2\11\1\1\1\0\1\11" + "\2\0\1\1\1\0\26\1\2\11\41\1";

	private static int[] zzUnpackAttribute()
	{
		int[] result = new int[217];
		int offset = 0;
		offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
		return result;
	}

	private static int zzUnpackAttribute(String packed, int offset, int[] result)
	{
		int i = 0; /* index in packed string */
		int j = offset; /* index in unpacked array */
		int l = packed.length();
		while (i < l)
		{
			int count = packed.charAt(i++);
			int value = packed.charAt(i++);
			do
				result[j++] = value;
			while (--count > 0);
		}
		return j;
	}

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/**
	 * this buffer contains the current text to be matched and is the source of the yytext() string
	 */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/**
	 * endRead marks the last character in the buffer, that has been read from input
	 */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the matched text
	 */
	private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/* user code: */
	// last token used for look behind. Also needed when implementing the ITokenScanner interface
	private Symbol _lastToken;

	// flag indicating if we should collect comments or not
	private boolean _collectComments = true;

	// accumulator of consecutive vsdoc lines, later added to vsdocComments as a single entity
	private List<Symbol> _vsdocAccumulator = new ArrayList<Symbol>();

	// comment collections, by type
	private List<Symbol> _sdocComments = new ArrayList<Symbol>();
	private List<Symbol> _vsdocComments = new ArrayList<Symbol>();
	private List<Symbol> _singleLineComments = new ArrayList<Symbol>();
	private List<Symbol> _multiLineComments = new ArrayList<Symbol>();

	public JSFlexScanner()
	{
		this((Reader) null);
	}

	public Symbol getLastToken()
	{
		return _lastToken;
	}

	public List<Symbol> getSDocComments()
	{
		return _sdocComments;
	}

	public List<Symbol> getVSDocComments()
	{
		return _vsdocComments;
	}

	public List<Symbol> getSingleLineComments()
	{
		return _singleLineComments;
	}

	public List<Symbol> getMultiLineComments()
	{
		return _multiLineComments;
	}

	private Symbol newToken(JSTokenType type, Object value)
	{
		return newToken(type.getIndex(), value);
	}

	private Symbol newToken(short id, Object value)
	{
		return new Symbol(id, yychar, yychar + yylength() - 1, value);
	}

	public Symbol nextToken() throws java.io.IOException, Scanner.Exception
	{
		// clear accumulators
		_vsdocAccumulator.clear();

		try
		{
			// get next token
			_lastToken = yylex();
		}
		catch (Scanner.Exception e)
		{
			// create default token type
			String text = yytext();
			int end = yychar + text.length() - 1;

			_lastToken = new Symbol(JSTokenType.EOF.getIndex(), yychar, end, text);
		}
		finally
		{
			// process any accumulated vsdoc lines
			if (!_vsdocAccumulator.isEmpty())
			{
				Symbol vsdoc = newToken(JSTokenType.VSDOC, new ArrayList<Symbol>(_vsdocAccumulator));

				_vsdocComments.add(vsdoc);
			}
		}

		return _lastToken;
	}

	private boolean isValidDivisionStart()
	{
		if (_lastToken != null)
		{
			switch (_lastToken.getId())
			{
				case Terminals.IDENTIFIER:
				case Terminals.NUMBER:
				case Terminals.REGEX:
				case Terminals.STRING:
				case Terminals.RPAREN:
				case Terminals.PLUS_PLUS:
				case Terminals.MINUS_MINUS:
				case Terminals.RBRACKET:
				case Terminals.RCURLY:
				case Terminals.FALSE:
				case Terminals.NULL:
				case Terminals.THIS:
				case Terminals.TRUE:
					return true;
			}
		}

		return false;
	}

	public void setCollectComments(boolean flag)
	{
		_collectComments = flag;
	}

	public void setSource(String source)
	{
		yyreset(new StringReader(source));

		// clear last token
		_lastToken = null;

		// reset comment collection lists
		_singleLineComments.clear();
		_multiLineComments.clear();
		_sdocComments.clear();
		_vsdocComments.clear();
	}

	/**
	 * Creates a new scanner There is also a java.io.InputStream version of this constructor.
	 * 
	 * @param in
	 *            the java.io.Reader to read input from.
	 */
	public JSFlexScanner(java.io.Reader in)
	{
		this.zzReader = in;
	}

	/**
	 * Creates a new scanner. There is also java.io.Reader version of this constructor.
	 * 
	 * @param in
	 *            the java.io.Inputstream to read input from.
	 */
	public JSFlexScanner(java.io.InputStream in)
	{
		this(new java.io.InputStreamReader(in));
	}

	/**
	 * Unpacks the compressed character translation table.
	 * 
	 * @param packed
	 *            the packed character translation table
	 * @return the unpacked character translation table
	 */
	private static char[] zzUnpackCMap(String packed)
	{
		char[] map = new char[0x10000];
		int i = 0; /* index in packed string */
		int j = 0; /* index in unpacked array */
		while (i < 1772)
		{
			int count = packed.charAt(i++);
			char value = packed.charAt(i++);
			do
				map[j++] = value;
			while (--count > 0);
		}
		return map;
	}

	/**
	 * Refills the input buffer.
	 * 
	 * @return <code>false</code>, iff there was new input.
	 * @exception java.io.IOException
	 *                if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException
	{

		/* first: make room (if you can) */
		if (zzStartRead > 0)
		{
			System.arraycopy(zzBuffer, zzStartRead, zzBuffer, 0, zzEndRead - zzStartRead);

			/* translate stored positions */
			zzEndRead -= zzStartRead;
			zzCurrentPos -= zzStartRead;
			zzMarkedPos -= zzStartRead;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length)
		{
			/* if not: blow it up */
			char newBuffer[] = new char[zzCurrentPos * 2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
		}

		/* finally: fill the buffer with new input */
		int numRead = zzReader.read(zzBuffer, zzEndRead, zzBuffer.length - zzEndRead);

		if (numRead > 0)
		{
			zzEndRead += numRead;
			return false;
		}
		// unlikely but not impossible: read 0 characters, but not at end of stream
		if (numRead == 0)
		{
			int c = zzReader.read();
			if (c == -1)
			{
				return true;
			}
			else
			{
				zzBuffer[zzEndRead++] = (char) c;
				return false;
			}
		}

		// numRead < 0
		return true;
	}

	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException
	{
		zzAtEOF = true; /* indicate end of file */
		zzEndRead = zzStartRead; /* invalidate buffer */

		if (zzReader != null)
			zzReader.close();
	}

	/**
	 * Resets the scanner to read from a new input stream. Does not close the old reader. All internal variables are
	 * reset, the old input stream <b>cannot</b> be reused (internal buffer is discarded and lost). Lexical state is set
	 * to <tt>ZZ_INITIAL</tt>.
	 * 
	 * @param reader
	 *            the new input stream
	 */
	public final void yyreset(java.io.Reader reader)
	{
		zzReader = reader;
		zzAtBOL = true;
		zzAtEOF = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = 0;
		yyline = yychar = yycolumn = 0;
		zzLexicalState = YYINITIAL;
	}

	/**
	 * Returns the current lexical state.
	 */
	public final int yystate()
	{
		return zzLexicalState;
	}

	/**
	 * Enters a new lexical state
	 * 
	 * @param newState
	 *            the new lexical state
	 */
	public final void yybegin(int newState)
	{
		zzLexicalState = newState;
	}

	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext()
	{
		return new String(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
	}

	/**
	 * Returns the character at position <tt>pos</tt> from the matched text. It is equivalent to yytext().charAt(pos),
	 * but faster
	 * 
	 * @param pos
	 *            the position of the character to fetch. A value from 0 to yylength()-1.
	 * @return the character at position pos
	 */
	public final char yycharat(int pos)
	{
		return zzBuffer[zzStartRead + pos];
	}

	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength()
	{
		return zzMarkedPos - zzStartRead;
	}

	/**
	 * Reports an error that occured while scanning. In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method will only be called with things that
	 * "Can't Possibly Happen". If this method is called, something is seriously wrong (e.g. a JFlex bug producing a
	 * faulty scanner etc.). Usual syntax/scanner level error handling should be done in error fallback rules.
	 * 
	 * @param errorCode
	 *            the code of the errormessage to display
	 */
	private void zzScanError(int errorCode)
	{
		String message;
		try
		{
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

		throw new Error(message);
	}

	/**
	 * Pushes the specified amount of characters back into the input stream. They will be read again by then next call
	 * of the scanning method
	 * 
	 * @param number
	 *            the number of characters to be read again. This number must not be greater than yylength()!
	 */
	public void yypushback(int number)
	{
		if (number > yylength())
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}

	/**
	 * Resumes scanning until the next regular expression is matched, the end of input is encountered or an I/O-Error
	 * occurs.
	 * 
	 * @return the next token
	 * @exception java.io.IOException
	 *                if any I/O-Error occurs
	 */
	public Symbol yylex() throws java.io.IOException, Scanner.Exception
	{
		int zzInput;
		int zzAction;

		// cached fields:
		int zzCurrentPosL;
		int zzMarkedPosL;
		int zzEndReadL = zzEndRead;
		char[] zzBufferL = zzBuffer;
		char[] zzCMapL = ZZ_CMAP;

		int[] zzTransL = ZZ_TRANS;
		int[] zzRowMapL = ZZ_ROWMAP;
		int[] zzAttrL = ZZ_ATTRIBUTE;

		while (true)
		{
			zzMarkedPosL = zzMarkedPos;

			yychar += zzMarkedPosL - zzStartRead;

			zzAction = -1;

			zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

			zzState = ZZ_LEXSTATE[zzLexicalState];

			zzForAction:
			{
				while (true)
				{

					if (zzCurrentPosL < zzEndReadL)
						zzInput = zzBufferL[zzCurrentPosL++];
					else if (zzAtEOF)
					{
						zzInput = YYEOF;
						break zzForAction;
					}
					else
					{
						// store back cached positions
						zzCurrentPos = zzCurrentPosL;
						zzMarkedPos = zzMarkedPosL;
						boolean eof = zzRefill();
						// get translated positions and possibly new buffer
						zzCurrentPosL = zzCurrentPos;
						zzMarkedPosL = zzMarkedPos;
						zzBufferL = zzBuffer;
						zzEndReadL = zzEndRead;
						if (eof)
						{
							zzInput = YYEOF;
							break zzForAction;
						}
						else
						{
							zzInput = zzBufferL[zzCurrentPosL++];
						}
					}
					int zzNext = zzTransL[zzRowMapL[zzState] + zzCMapL[zzInput]];
					if (zzNext == -1)
						break zzForAction;
					zzState = zzNext;

					int zzAttributes = zzAttrL[zzState];
					if ((zzAttributes & 1) == 1)
					{
						zzAction = zzState;
						zzMarkedPosL = zzCurrentPosL;
						if ((zzAttributes & 8) == 8)
							break zzForAction;
					}

				}
			}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction])
			{
				case 13:
				{
					yypushback(1);
					if (isValidDivisionStart())
					{
						yybegin(DIVISION);
					}
					else
					{
						yybegin(REGEX);
					}
				}
				case 88:
					break;
				case 38:
				{
					if (_collectComments)
					{
						_singleLineComments.add(newToken(JSTokenType.SINGLELINE_COMMENT, yytext()));
					}
				}
				case 89:
					break;
				case 81:
				{
					return newToken(Terminals.TYPEOF, yytext());
				}
				case 90:
					break;
				case 37:
				{
					return newToken(Terminals.STRING, yytext());
				}
				case 91:
					break;
				case 16:
				{
					return newToken(Terminals.RBRACKET, yytext());
				}
				case 92:
					break;
				case 12:
				{
					return newToken(Terminals.PLUS, yytext());
				}
				case 93:
					break;
				case 78:
				{
					return newToken(Terminals.WHILE, yytext());
				}
				case 94:
					break;
				case 77:
				{
					return newToken(Terminals.THROW, yytext());
				}
				case 95:
					break;
				case 33:
				{
					return newToken(Terminals.GREATER_GREATER, yytext());
				}
				case 96:
					break;
				case 15:
				{
					return newToken(Terminals.LBRACKET, yytext());
				}
				case 97:
					break;
				case 75:
				{
					return newToken(Terminals.BREAK, yytext());
				}
				case 98:
					break;
				case 82:
				{
					return newToken(Terminals.DELETE, yytext());
				}
				case 99:
					break;
				case 36:
				{
					return newToken(Terminals.PLUS_EQUAL, yytext());
				}
				case 100:
					break;
				case 67:
				{
					return newToken(Terminals.CASE, yytext());
				}
				case 101:
					break;
				case 42:
				{
					return newToken(Terminals.DO, yytext());
				}
				case 102:
					break;
				case 48:
				{
					return newToken(Terminals.PIPE_PIPE, yytext());
				}
				case 103:
					break;
				case 62:
				{
					return newToken(Terminals.EXCLAMATION_EQUAL_EQUAL, yytext());
				}
				case 104:
					break;
				case 58:
				{
					return newToken(Terminals.TRY, yytext());
				}
				case 105:
					break;
				case 29:
				{
					yybegin(YYINITIAL);
					return newToken(Terminals.FORWARD_SLASH, yytext());
				}
				case 106:
					break;
				case 79:
				{
					return newToken(Terminals.RETURN, yytext());
				}
				case 107:
					break;
				case 85:
				{
					return newToken(Terminals.FUNCTION, yytext());
				}
				case 108:
					break;
				case 34:
				{
					return newToken(Terminals.GREATER_EQUAL, yytext());
				}
				case 109:
					break;
				case 32:
				{
					return newToken(Terminals.PERCENT_EQUAL, yytext());
				}
				case 110:
					break;
				case 21:
				{
					return newToken(Terminals.MINUS, yytext());
				}
				case 111:
					break;
				case 27:
				{
					return newToken(Terminals.COMMA, yytext());
				}
				case 112:
					break;
				case 74:
				{
					return newToken(Terminals.FALSE, yytext());
				}
				case 113:
					break;
				case 6:
				{
					return newToken(Terminals.QUESTION, yytext());
				}
				case 114:
					break;
				case 44:
				{
					return newToken(Terminals.EXCLAMATION_EQUAL, yytext());
				}
				case 115:
					break;
				case 56:
				{
					if (_collectComments)
					{
						_vsdocAccumulator.add(newToken(JSTokenType.VSDOC, yytext()));
					}
				}
				case 116:
					break;
				case 23:
				{
					return newToken(Terminals.TILDE, yytext());
				}
				case 117:
					break;
				case 87:
				{
					return newToken(Terminals.INSTANCEOF, yytext());
				}
				case 118:
					break;
				case 63:
				{
					yybegin(YYINITIAL);
					return newToken(Terminals.REGEX, yytext());
				}
				case 119:
					break;
				case 51:
				{
					return newToken(Terminals.CARET_EQUAL, yytext());
				}
				case 120:
					break;
				case 26:
				{
					return newToken(Terminals.RPAREN, yytext());
				}
				case 121:
					break;
				case 8:
				{
					return newToken(Terminals.RCURLY, yytext());
				}
				case 122:
					break;
				case 18:
				{
					return newToken(Terminals.EXCLAMATION, yytext());
				}
				case 123:
					break;
				case 60:
				{
					return newToken(Terminals.VAR, yytext());
				}
				case 124:
					break;
				case 45:
				{
					return newToken(Terminals.AMPERSAND_EQUAL, yytext());
				}
				case 125:
					break;
				case 25:
				{
					return newToken(Terminals.LPAREN, yytext());
				}
				case 126:
					break;
				case 22:
				{
					return newToken(Terminals.CARET, yytext());
				}
				case 127:
					break;
				case 35:
				{
					return newToken(Terminals.PLUS_PLUS, yytext());
				}
				case 128:
					break;
				case 84:
				{
					return newToken(Terminals.DEFAULT, yytext());
				}
				case 129:
					break;
				case 17:
				{
					return newToken(Terminals.EQUAL, yytext());
				}
				case 130:
					break;
				case 66:
				{
					return newToken(Terminals.ELSE, yytext());
				}
				case 131:
					break;
				case 72:
				{
					return newToken(Terminals.VOID, yytext());
				}
				case 132:
					break;
				case 10:
				{
					return newToken(Terminals.NUMBER, yytext());
				}
				case 133:
					break;
				case 69:
				{
					return newToken(Terminals.THIS, yytext());
				}
				case 134:
					break;
				case 64:
				{
					return newToken(Terminals.GREATER_GREATER_GREATER_EQUAL, yytext());
				}
				case 135:
					break;
				case 52:
				{
					yybegin(YYINITIAL);
					return newToken(Terminals.FORWARD_SLASH_EQUAL, yytext());
				}
				case 136:
					break;
				case 11:
				{
					return newToken(Terminals.DOT, yytext());
				}
				case 137:
					break;
				case 7:
				{
					return newToken(Terminals.LCURLY, yytext());
				}
				case 138:
					break;
				case 30:
				{
					return newToken(Terminals.LESS_LESS, yytext());
				}
				case 139:
					break;
				case 43:
				{
					return newToken(Terminals.EQUAL_EQUAL, yytext());
				}
				case 140:
					break;
				case 40:
				{
					return newToken(Terminals.IF, yytext());
				}
				case 141:
					break;
				case 3:
				{
					return newToken(Terminals.LESS, yytext());
				}
				case 142:
					break;
				case 4:
				{
					return newToken(Terminals.PERCENT, yytext());
				}
				case 143:
					break;
				case 55:
				{
					return newToken(Terminals.GREATER_GREATER_EQUAL, yytext());
				}
				case 144:
					break;
				case 54:
				{
					return newToken(Terminals.GREATER_GREATER_GREATER, yytext());
				}
				case 145:
					break;
				case 73:
				{
					if (_collectComments)
					{
						_sdocComments.add(newToken(JSTokenType.SDOC, yytext()));
					}
				}
				case 146:
					break;
				case 59:
				{
					return newToken(Terminals.NEW, yytext());
				}
				case 147:
					break;
				case 20:
				{
					return newToken(Terminals.PIPE, yytext());
				}
				case 148:
					break;
				case 5:
				{
					return newToken(Terminals.GREATER, yytext());
				}
				case 149:
					break;
				case 57:
				{
					return newToken(Terminals.FOR, yytext());
				}
				case 150:
					break;
				case 70:
				{
					return newToken(Terminals.NULL, yytext());
				}
				case 151:
					break;
				case 83:
				{
					return newToken(Terminals.FINALLY, yytext());
				}
				case 152:
					break;
				case 68:
				{
					return newToken(Terminals.TRUE, yytext());
				}
				case 153:
					break;
				case 24:
				{
					return newToken(Terminals.SEMICOLON, yytext());
				}
				case 154:
					break;
				case 47:
				{
					return newToken(Terminals.PIPE_EQUAL, yytext());
				}
				case 155:
					break;
				case 50:
				{
					return newToken(Terminals.MINUS_MINUS, yytext());
				}
				case 156:
					break;
				case 31:
				{
					return newToken(Terminals.LESS_EQUAL, yytext());
				}
				case 157:
					break;
				case 53:
				{
					return newToken(Terminals.LESS_LESS_EQUAL, yytext());
				}
				case 158:
					break;
				case 14:
				{
					return newToken(Terminals.STAR, yytext());
				}
				case 159:
					break;
				case 28:
				{
					return newToken(Terminals.COLON, yytext());
				}
				case 160:
					break;
				case 61:
				{
					return newToken(Terminals.EQUAL_EQUAL_EQUAL, yytext());
				}
				case 161:
					break;
				case 46:
				{
					return newToken(Terminals.AMPERSAND_AMPERSAND, yytext());
				}
				case 162:
					break;
				case 86:
				{
					return newToken(Terminals.CONTINUE, yytext());
				}
				case 163:
					break;
				case 49:
				{
					return newToken(Terminals.MINUS_EQUAL, yytext());
				}
				case 164:
					break;
				case 65:
				{
					if (_collectComments)
					{
						_multiLineComments.add(newToken(JSTokenType.MULTILINE_COMMENT, yytext()));
					}
				}
				case 165:
					break;
				case 2:
				{ /* ignore */
				}
				case 166:
					break;
				case 41:
				{
					return newToken(Terminals.IN, yytext());
				}
				case 167:
					break;
				case 76:
				{
					return newToken(Terminals.CATCH, yytext());
				}
				case 168:
					break;
				case 39:
				{
					return newToken(Terminals.STAR_EQUAL, yytext());
				}
				case 169:
					break;
				case 9:
				{
					return newToken(Terminals.IDENTIFIER, yytext());
				}
				case 170:
					break;
				case 19:
				{
					return newToken(Terminals.AMPERSAND, yytext());
				}
				case 171:
					break;
				case 1:
				{ // make sure we reset the lexer state for next (potential) scan
					yybegin(YYINITIAL);
					throw new Scanner.Exception("Unexpected character '" + yytext() + "' around offset " + yychar);
				}
				case 172:
					break;
				case 80:
				{
					return newToken(Terminals.SWITCH, yytext());
				}
				case 173:
					break;
				case 71:
				{
					return newToken(Terminals.WITH, yytext());
				}
				case 174:
					break;
				default:
					if (zzInput == YYEOF && zzStartRead == zzCurrentPos)
					{
						zzAtEOF = true;
						{
							return newToken(Terminals.EOF, "end-of-file");
						}
					}
					else
					{
						zzScanError(ZZ_NO_MATCH);
					}
			}
		}
	}

}
